/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.editor.windows.clipboard;

import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.blueprint.Blueprint;
import com.moulberry.axiom.blueprint.BlueprintHeader;
import com.moulberry.axiom.blueprint.BlueprintIo;
import com.moulberry.axiom.blueprint.RawBlueprint;
import com.moulberry.axiom.blueprint.ServerBlueprintRegistry;
import com.moulberry.axiom.clipboard.Clipboard;
import com.moulberry.axiom.collections.FlowCache;
import com.moulberry.axiom.configuration.BlueprintConfiguration;
import com.moulberry.axiom.configuration.Configuration;
import com.moulberry.axiom.editor.BlueprintPreview;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.editor.EditorWindowType;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.editor.widgets.TagListWidget;
import com.moulberry.axiom.editor.windows.clipboard.BlueprintDirectory;
import com.moulberry.axiom.editor.windows.clipboard.BlueprintOrDirectory;
import com.moulberry.axiom.editor.windows.clipboard.PathWrapper;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.packets.blueprint.AxiomServerboundRequestBlueprint;
import com.moulberry.axiom.packets.blueprint.AxiomServerboundUploadBlueprint;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.world_modification.CompressedBlockEntity;
import imgui.ImGui;
import imgui.ImGuiListClipper;
import imgui.ImVec2;
import imgui.callback.ImListClipperCallback;
import imgui.type.ImString;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileAttribute;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1047;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.MemoryStack;

public class BlueprintBrowserWindow {
    public static final Thumbnail EMPTY_THUMBNAIL = new Thumbnail(null);
    public static final Set<Path> updatedBlueprintPaths = new HashSet<Path>();
    private static final ImString searchString = new ImString(64);
    private static final ImString renameFilenameString = new ImString(64);
    private static String noLongerExistsErrorFileName = null;
    private static boolean reloadDirectoryStructure = false;
    private static BlueprintDirectory rootDirectory = null;
    private static BlueprintDirectory currentDirectory = null;
    private static EditBlueprintData editBlueprintData = null;
    private static final Set<String> filteredTags = new TreeSet<String>();
    private static boolean filteredTagsChanged = false;
    private static Exception displayedException = null;
    private static MoveFileOperation moveFileOperation = null;
    public static BlueprintDirectory pendingSelectDirectory = null;
    private static boolean dirStructureToggled = false;
    public static boolean anyOrderUpdated = false;
    private static int updateOrderingCounter = 0;
    private static boolean renderedAtLeastOnce = false;
    private static int tooManyFileChangesCount = -1;
    private static WatchService watchService = null;
    private static final Map<Path, BlueprintDirectory> dirStructureMap = new HashMap<Path, BlueprintDirectory>();
    private static ServerBlueprintRegistry serverBlueprintRegistry = null;
    private static BlueprintDirectory rootServerBlueprintDirectory = null;
    public static String pendingServerBlueprintDownload = null;
    public static Blueprint pendingServerBlueprintResult = null;
    private static boolean justOpened = false;
    public static boolean selectMultiple = false;
    private static Predicate<Blueprint> callback = BlueprintBrowserWindow::defaultCallback;
    private static final FlowCache<PathWrapper, Thumbnail> loadedBlueprintThumbnails = new FlowCache<PathWrapper, Thumbnail>(0, 16, 1, 1, true, path -> {
        if (path.real() != null) {
            Thumbnail thumbnail;
            if (Files.isDirectory(path.real(), new LinkOption[0])) {
                return EMPTY_THUMBNAIL;
            }
            BufferedInputStream inputStream = new BufferedInputStream(Files.newInputStream(path.real(), new OpenOption[0]));
            try {
                thumbnail = new Thumbnail(BlueprintIo.readThumbnail(inputStream));
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)inputStream).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return EMPTY_THUMBNAIL;
                }
            }
            ((InputStream)inputStream).close();
            return thumbnail;
        }
        RawBlueprint rawBlueprint = serverBlueprintRegistry.blueprints().get(path.fakePath());
        if (rawBlueprint == null) {
            return EMPTY_THUMBNAIL;
        }
        try {
            class_1011 nativeImage;
            try (MemoryStack memoryStack = MemoryStack.stackPush();){
                ByteBuffer byteBuffer = memoryStack.malloc(rawBlueprint.thumbnail().length);
                byteBuffer.put(rawBlueprint.thumbnail());
                byteBuffer.rewind();
                nativeImage = class_1011.method_4324((ByteBuffer)byteBuffer);
            }
            return new Thumbnail(new class_1043(nativeImage));
        }
        catch (Exception ignored) {
            return EMPTY_THUMBNAIL;
        }
    });
    private static final int ICON_SIZE = 100;

    public static void open(@Nullable Predicate<Blueprint> callback, boolean selectMultiple) {
        EditorWindowType.BLUEPRINT_BROWSER.setOpen(true);
        BlueprintBrowserWindow.callback = callback == null ? BlueprintBrowserWindow::defaultCallback : callback;
        BlueprintBrowserWindow.selectMultiple = selectMultiple;
        justOpened = true;
    }

    public static void resetCallback() {
        callback = BlueprintBrowserWindow::defaultCallback;
        selectMultiple = false;
    }

    public static void setServerBlueprintRegistry(boolean replace, ServerBlueprintRegistry registry) {
        pendingServerBlueprintDownload = null;
        if (registry == null) {
            serverBlueprintRegistry = null;
        } else if (replace || serverBlueprintRegistry == null) {
            serverBlueprintRegistry = registry;
        } else {
            for (Map.Entry<String, RawBlueprint> entry : registry.blueprints().entrySet()) {
                serverBlueprintRegistry.blueprints().put(entry.getKey(), entry.getValue());
            }
        }
        if (rootServerBlueprintDirectory != null) {
            BlueprintDirectory currentRoot = currentDirectory;
            while (currentRoot.parent() != null) {
                currentRoot = currentRoot.parent();
            }
            if (rootServerBlueprintDirectory.equals(currentRoot)) {
                currentDirectory = rootDirectory;
            }
            rootServerBlueprintDirectory = null;
        }
    }

    private static BlueprintDirectory createHierarchical(Map<String, Object> hierarchical, String name, String path) {
        BlueprintDirectory directory = new BlueprintDirectory(new PathWrapper(null, path), name);
        for (Map.Entry<String, Object> child : hierarchical.entrySet()) {
            Object object = child.getValue();
            if (object instanceof RawBlueprint) {
                RawBlueprint rawBlueprint = (RawBlueprint)object;
                directory.addLast(new BlueprintOrDirectory.Bp(new PathWrapper(null, path + child.getKey()), rawBlueprint.header()));
                continue;
            }
            Map map = (Map)child.getValue();
            BlueprintDirectory childDirectory = BlueprintBrowserWindow.createHierarchical(map, child.getKey(), path + child.getKey() + "/");
            directory.addLast(new BlueprintOrDirectory.Dir(childDirectory));
        }
        directory.sort(BlueprintDirectory.SortMode.NAME);
        return directory;
    }

    private static boolean defaultCallback(Blueprint blueprint) {
        Clipboard.INSTANCE.setClipboard(blueprint);
        return true;
    }

    private static BlueprintOrDirectory loadBlueprintOrDirectory(Path path) {
        BlueprintOrDirectory.Bp bp;
        if (Files.isDirectory(path, new LinkOption[0])) {
            String subname = path.getFileName().toString();
            BlueprintDirectory substructure = BlueprintBrowserWindow.loadDirectory(subname, path);
            return new BlueprintOrDirectory.Dir(substructure);
        }
        BufferedInputStream inputStream = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]), 2048);
        try {
            BlueprintHeader blueprintHeader = BlueprintIo.readHeader(inputStream);
            bp = new BlueprintOrDirectory.Bp(new PathWrapper(path, null), blueprintHeader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception exception) {
                return null;
            }
        }
        ((InputStream)inputStream).close();
        return bp;
    }

    private static BlueprintDirectory loadDirectory(String name, Path path) {
        BlueprintOrDirectory blueprintOrDirectory;
        HashSet<Path> loadedPaths = new HashSet<Path>();
        BlueprintDirectory blueprintDirectory = new BlueprintDirectory(new PathWrapper(path, null), name);
        try {
            if (watchService != null) {
                path.register(watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
            }
            dirStructureMap.put(path, blueprintDirectory);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        Path dotfile = path.resolve(".axiom_blueprint_ordering");
        if (Files.exists(dotfile, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(dotfile);){
                String line;
                while ((line = reader.readLine()) != null) {
                    Path subpath = path.resolve(line.replace("/", path.getFileSystem().getSeparator()));
                    if (!loadedPaths.add(subpath) || (blueprintOrDirectory = BlueprintBrowserWindow.loadBlueprintOrDirectory(subpath)) == null) continue;
                    blueprintDirectory.addLast(blueprintOrDirectory);
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        try (DirectoryStream<Path> ds = Files.newDirectoryStream(path);){
            for (Path subpath : ds) {
                if (loadedPaths.contains(subpath) || subpath.getFileName().toString().startsWith(".") || (blueprintOrDirectory = BlueprintBrowserWindow.loadBlueprintOrDirectory(subpath)) == null) continue;
                blueprintDirectory.addLast(blueprintOrDirectory);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return blueprintDirectory;
    }

    private static void updateOrdering(BlueprintDirectory blueprintDirectory) {
        blueprintDirectory.saveOrdering();
        for (BlueprintDirectory child : blueprintDirectory.children()) {
            BlueprintBrowserWindow.updateOrdering(child);
        }
    }

    public static void tick() {
        if (!renderedAtLeastOnce) {
            return;
        }
        if (Axiom.getInstance().hasCommercialLicense() && serverBlueprintRegistry != null && rootServerBlueprintDirectory == null) {
            HashMap<String, Object> hierarchical = new HashMap<String, Object>();
            for (Map.Entry<String, RawBlueprint> entry : serverBlueprintRegistry.blueprints().entrySet()) {
                String path = entry.getKey();
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                String[] paths = path.split("/");
                Map<String, Object> map = hierarchical;
                for (int i = 0; i < paths.length; ++i) {
                    String name = paths[i];
                    if (i < paths.length - 1) {
                        map = (Map)map.computeIfAbsent(name, k -> new HashMap());
                        continue;
                    }
                    map.put(name, entry.getValue());
                }
            }
            rootServerBlueprintDirectory = BlueprintBrowserWindow.createHierarchical(hierarchical, "Server Blueprints", "/");
        }
        boolean automaticRefreshing = Configuration.blueprint.automaticRefreshing;
        loadedBlueprintThumbnails.tick();
        if (pendingSelectDirectory != null) {
            BlueprintBrowserWindow.setCurrentDirectory(pendingSelectDirectory);
            pendingSelectDirectory = null;
        }
        if (moveFileOperation != null) {
            BlueprintBrowserWindow.handleMoveFileOperation();
        }
        if (watchService != null) {
            if (!automaticRefreshing) {
                try {
                    watchService.close();
                    watchService = null;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            } else {
                BlueprintBrowserWindow.pollAndUpdateWatchService();
            }
        }
        for (Path updatedPath : updatedBlueprintPaths) {
            BlueprintOrDirectory blueprintOrDirectory;
            BlueprintDirectory blueprintDirectory = dirStructureMap.get(updatedPath.getParent());
            if (blueprintDirectory == null) continue;
            if (!Files.exists(updatedPath, new LinkOption[0])) {
                blueprintDirectory.remove(new PathWrapper(updatedPath, null));
                continue;
            }
            Thumbnail texture = loadedBlueprintThumbnails.remove(new PathWrapper(updatedPath, null));
            if (texture != null) {
                texture.close();
            }
            if ((blueprintOrDirectory = BlueprintBrowserWindow.loadBlueprintOrDirectory(updatedPath)) == null) continue;
            blueprintDirectory.addLast(blueprintOrDirectory);
        }
        updatedBlueprintPaths.clear();
        if (rootDirectory == null || reloadDirectoryStructure || automaticRefreshing && watchService == null) {
            if (rootDirectory != null && anyOrderUpdated) {
                BlueprintBrowserWindow.updateOrdering(rootDirectory);
                anyOrderUpdated = false;
            }
            searchString.clear();
            filteredTags.clear();
            if (automaticRefreshing) {
                try {
                    if (watchService != null) {
                        watchService.close();
                    }
                    watchService = FileSystems.getDefault().newWatchService();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            dirStructureMap.clear();
            Path rootPath = FabricLoader.getInstance().getConfigDir().resolve("axiom").resolve("blueprints");
            rootDirectory = currentDirectory = BlueprintBrowserWindow.loadDirectory("Blueprints", rootPath);
            loadedBlueprintThumbnails.clear();
            reloadDirectoryStructure = false;
            anyOrderUpdated = false;
            updateOrderingCounter = 0;
        }
        if (filteredTagsChanged) {
            if (currentDirectory != null) {
                currentDirectory.search(ImGuiHelper.getString(searchString), filteredTags);
            }
            filteredTagsChanged = false;
        }
        if (anyOrderUpdated) {
            if (updateOrderingCounter < 200) {
                ++updateOrderingCounter;
            } else {
                BlueprintBrowserWindow.updateOrdering(rootDirectory);
                updateOrderingCounter = 0;
                anyOrderUpdated = false;
            }
        }
    }

    private static void handleMoveFileOperation() {
        if (BlueprintBrowserWindow.moveFileOperation.to.equals(BlueprintBrowserWindow.moveFileOperation.from)) {
            if (BlueprintBrowserWindow.moveFileOperation.repositionReference != null) {
                BlueprintBrowserWindow.moveFileOperation.to.reposition(BlueprintBrowserWindow.moveFileOperation.file, BlueprintBrowserWindow.moveFileOperation.repositionReference, BlueprintBrowserWindow.moveFileOperation.repositionBefore);
            }
            moveFileOperation = null;
        } else if (!BlueprintBrowserWindow.moveFileOperation.pendingOverwriteConfirmation || BlueprintBrowserWindow.moveFileOperation.overwriteConfirmation) {
            try {
                Path path = BlueprintBrowserWindow.getNewPath(BlueprintBrowserWindow.moveFileOperation.to, BlueprintBrowserWindow.moveFileOperation.file);
                BlueprintBrowserWindow.moveBlueprint(BlueprintBrowserWindow.moveFileOperation.file, path, BlueprintBrowserWindow.moveFileOperation.overwriteConfirmation);
                if (BlueprintBrowserWindow.moveFileOperation.from.remove(BlueprintBrowserWindow.moveFileOperation.file.path())) {
                    BlueprintBrowserWindow.moveFileOperation.file.path(path);
                    if (BlueprintBrowserWindow.moveFileOperation.overwriteConfirmation) {
                        BlueprintBrowserWindow.moveFileOperation.to.remove(BlueprintBrowserWindow.moveFileOperation.file.path());
                    }
                    BlueprintBrowserWindow.moveFileOperation.to.addLast(BlueprintBrowserWindow.moveFileOperation.file);
                } else {
                    reloadDirectoryStructure = true;
                }
                moveFileOperation = null;
            }
            catch (FileNotFoundException | NoSuchFileException e) {
                noLongerExistsErrorFileName = BlueprintBrowserWindow.moveFileOperation.file.path().getFileName();
                moveFileOperation = null;
            }
            catch (FileAlreadyExistsException e) {
                if (BlueprintBrowserWindow.moveFileOperation.overwriteConfirmation) {
                    displayedException = e;
                    moveFileOperation = null;
                    e.printStackTrace();
                } else {
                    BlueprintBrowserWindow.moveFileOperation.pendingOverwriteConfirmation = true;
                }
            }
            catch (Exception e) {
                displayedException = e;
                moveFileOperation = null;
                e.printStackTrace();
            }
        }
    }

    private static void pollAndUpdateWatchService() {
        WatchKey key;
        while ((key = watchService.poll()) != null) {
            Path keyPath = (Path)key.watchable();
            for (WatchEvent<?> event : key.pollEvents()) {
                BlueprintOrDirectory blueprintOrDirectory;
                Path filename;
                WatchEvent.Kind<?> kind = event.kind();
                if (kind == StandardWatchEventKinds.OVERFLOW) {
                    if (tooManyFileChangesCount < 0) {
                        tooManyFileChangesCount = 0;
                    }
                    tooManyFileChangesCount += Math.max(0, event.count());
                    continue;
                }
                Object obj = event.context();
                if (!(obj instanceof Path) || (filename = (Path)obj).getFileName().toString().startsWith(".")) continue;
                Path absolute = keyPath.resolve(filename);
                updatedBlueprintPaths.remove(absolute);
                BlueprintDirectory blueprintDirectory = dirStructureMap.get(keyPath);
                if (blueprintDirectory == null) continue;
                if (kind == StandardWatchEventKinds.ENTRY_DELETE) {
                    blueprintDirectory.remove(new PathWrapper(absolute, null));
                    continue;
                }
                if (kind != StandardWatchEventKinds.ENTRY_CREATE && kind != StandardWatchEventKinds.ENTRY_MODIFY) continue;
                Thumbnail texture = loadedBlueprintThumbnails.remove(new PathWrapper(absolute, null));
                if (texture != null) {
                    texture.close();
                }
                if ((blueprintOrDirectory = BlueprintBrowserWindow.loadBlueprintOrDirectory(absolute)) == null) continue;
                blueprintDirectory.addLast(blueprintOrDirectory);
            }
            if (key.reset()) continue;
            BlueprintDirectory blueprintDirectory = dirStructureMap.remove(keyPath);
            if (blueprintDirectory != null && blueprintDirectory.parent() != null) {
                blueprintDirectory.parent().remove(new PathWrapper(keyPath, null));
            }
            if (pendingSelectDirectory != null && pendingSelectDirectory.equals(blueprintDirectory)) {
                pendingSelectDirectory = null;
            }
            if (currentDirectory == null || !currentDirectory.equals(blueprintDirectory)) continue;
            currentDirectory = rootDirectory;
        }
    }

    private static void setCurrentDirectory(BlueprintDirectory structure) {
        if (currentDirectory != null && currentDirectory.equals(structure)) {
            return;
        }
        if (currentDirectory != null) {
            currentDirectory.search("", Set.of());
            searchString.set("");
        }
        currentDirectory = structure;
        structure.search("", filteredTags);
    }

    private static void renderDirectoryOverview(BlueprintDirectory blueprintDirectory, String id) {
        int flags = 4096;
        if (blueprintDirectory.children().isEmpty()) {
            flags |= 0x200;
        } else if (currentDirectory != blueprintDirectory) {
            flags |= 0x80;
        }
        if (blueprintDirectory.equals(rootDirectory)) {
            flags |= 0x20;
        }
        id = (String)id + blueprintDirectory.dirName();
        if (currentDirectory != null && currentDirectory.equals(blueprintDirectory)) {
            flags |= 1;
        }
        String formattedCount = NumberFormat.getInstance().format(blueprintDirectory.blueprints().size());
        boolean treeNodeOpen = ImGui.treeNodeEx(blueprintDirectory.dirName() + " (" + formattedCount + ")###DirOverview" + (String)id, flags);
        if (ImGui.isItemHovered() && ImGui.isMouseReleased(0) && (!(dirStructureToggled |= ImGui.isItemToggledOpen()) || blueprintDirectory.children().isEmpty())) {
            pendingSelectDirectory = blueprintDirectory;
        }
        if (ImGui.beginDragDropTarget()) {
            BlueprintOrDirectory blueprintOrDirectory = (BlueprintOrDirectory)ImGui.acceptDragDropPayload("BlueprintOrDirectory", 3072);
            if (blueprintOrDirectory != null) {
                ImVec2 min2 = ImGui.getItemRectMin();
                ImVec2 max2 = ImGui.getItemRectMax();
                ImGui.getForegroundDrawList().addRect(min2.x - 3.5f, min2.y - 3.5f, max2.x + 3.5f, max2.y + 3.5f, ImGui.getColorU32(50), 0.0f, 0, 2.0f);
                if (ImGui.isMouseReleased(0)) {
                    moveFileOperation = new MoveFileOperation(currentDirectory, blueprintDirectory, blueprintOrDirectory);
                }
            }
            ImGui.endDragDropTarget();
        }
        if (treeNodeOpen) {
            for (BlueprintDirectory child : blueprintDirectory.children()) {
                BlueprintBrowserWindow.renderDirectoryOverview(child, (String)id);
            }
            ImGui.treePop();
        }
    }

    public static void render() {
        if (pendingServerBlueprintDownload != null) {
            if (pendingServerBlueprintResult == null) {
                if (!ImGui.isPopupOpen("###DownloadingModal")) {
                    ImGui.openPopup("###DownloadingModal");
                }
                if (ImGuiHelper.beginPopupModal("###DownloadingModal", 325)) {
                    ImGui.text("Downloading blueprint...");
                    if (ImGui.button("Cancel")) {
                        pendingServerBlueprintDownload = null;
                    }
                    ImGui.endPopup();
                }
                return;
            }
            boolean success = callback.test(pendingServerBlueprintResult);
            if (!success) {
                callback = BlueprintBrowserWindow::defaultCallback;
                selectMultiple = false;
                callback.test(pendingServerBlueprintResult);
            }
            if (!(selectMultiple && ImGui.getIO().getKeyShift() || EditorWindowType.BLUEPRINT_BROWSER.isDocked())) {
                EditorWindowType.BLUEPRINT_BROWSER.setOpen(false);
            }
            pendingServerBlueprintDownload = null;
            pendingServerBlueprintResult = null;
        }
        if (pendingServerBlueprintResult != null) {
            pendingServerBlueprintResult.close();
            pendingServerBlueprintResult = null;
        }
        if (!EditorWindowType.BLUEPRINT_BROWSER.isOpen()) {
            selectMultiple = false;
            callback = BlueprintBrowserWindow::defaultCallback;
            justOpened = true;
            return;
        }
        ImVec2 center = ImGui.getMainViewport().getCenter();
        if (justOpened) {
            ImGui.setNextWindowPos(center.x, center.y, 1, 0.5f, 0.5f);
            ImGui.setNextWindowSize(720.0f, 500.0f, 2);
            justOpened = false;
        }
        ImGui.setNextWindowSizeConstraints(510.0f, 350.0f, 5000.0f, 3000.0f);
        if (EditorWindowType.BLUEPRINT_BROWSER.begin("###OpenBlueprint", true)) {
            BlueprintBrowserWindow.renderInner(center);
        }
        EditorWindowType.BLUEPRINT_BROWSER.end();
        if (!ImGui.isMouseDown(0)) {
            dirStructureToggled = false;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void renderInner(ImVec2 center) {
        boolean backDisabled;
        renderedAtLeastOnce = true;
        if (tooManyFileChangesCount >= 0) {
            ImGui.setNextWindowPos(center.x, center.y, 1, 0.5f, 0.5f);
            if (ImGui.beginPopupModal(AxiomI18n.get("axiom.editorui.window.blueprint_browser.overflow_files") + "###TooManyFileChangesPopup", 64)) {
                ImGui.pushTextWrapPos(600.0f);
                Object message = AxiomI18n.get("axiom.editorui.window.blueprint_browser.overflow_files_message");
                if (tooManyFileChangesCount > 0) {
                    message = (String)message + " (" + NumberFormat.getInstance().format(tooManyFileChangesCount) + "+)";
                }
                ImGui.text((String)message);
                ImGui.popTextWrapPos();
                if (ImGui.button(AxiomI18n.get("axiom.editorui.window.blueprint_browser.reload"))) {
                    reloadDirectoryStructure = true;
                    tooManyFileChangesCount = -1;
                    ImGui.closeCurrentPopup();
                }
                ImGui.sameLine();
                if (ImGui.button(AxiomI18n.get("axiom.editorui.window.blueprint_browser.disable_auto_refresh"))) {
                    tooManyFileChangesCount = -1;
                }
                EditorUI.consumeNavClose();
                ImGui.endPopup();
            } else {
                ImGui.openPopup("###TooManyFileChangesPopup");
            }
            moveFileOperation = null;
        } else if (noLongerExistsErrorFileName != null) {
            ImGui.setNextWindowPos(center.x, center.y, 1, 0.5f, 0.5f);
            if (ImGui.beginPopupModal(AxiomI18n.get("axiom.editorui.window.blueprint_browser.file_missing") + "###NoLongerExistsErrorPopup", 64)) {
                String osFileBrowser = switch (class_156.method_668()) {
                    case class_156.class_158.field_1137 -> AxiomI18n.get("axiom.editorui.window.blueprint_browser.file_browser_osx");
                    case class_156.class_158.field_1133 -> AxiomI18n.get("axiom.editorui.window.blueprint_browser.file_browser_win");
                    default -> AxiomI18n.get("axiom.editorui.window.blueprint_browser.file_browser_other");
                };
                ImGui.pushTextWrapPos(600.0f);
                ImGui.text(AxiomI18n.get("axiom.editorui.window.blueprint_browser.file_missing_message1", noLongerExistsErrorFileName));
                ImGui.text(AxiomI18n.get("axiom.editorui.window.blueprint_browser.file_missing_message2", osFileBrowser));
                ImGui.popTextWrapPos();
                if (ImGui.button(AxiomI18n.get("axiom.editorui.window.blueprint_browser.reload"))) {
                    reloadDirectoryStructure = true;
                    noLongerExistsErrorFileName = null;
                    ImGui.closeCurrentPopup();
                }
                EditorUI.consumeNavClose();
                ImGui.endPopup();
            } else {
                ImGui.openPopup("###NoLongerExistsErrorPopup");
            }
            moveFileOperation = null;
        } else if (editBlueprintData != null) {
            ImGui.setNextWindowPos(center.x, center.y, 1, 0.5f, 0.5f);
            String editBlueprint = AxiomI18n.get("axiom.editorui.window.blueprint_browser.edit_blueprint");
            if (!ImGui.isPopupOpen(editBlueprint + "###EditBlueprintPopup")) {
                ImGui.openPopup("###EditBlueprintPopup");
            }
            if (ImGuiHelper.beginPopupModalCloseable(editBlueprint + "###EditBlueprintPopup", 64)) {
                BlueprintBrowserWindow.editBlueprintPopup();
                ImGuiHelper.endPopupModalCloseable();
            }
            if (!ImGui.isPopupOpen(editBlueprint + "###EditBlueprintPopup") && editBlueprintData != null) {
                BlueprintBrowserWindow.editBlueprintData.fallbackPreview.close();
                editBlueprintData = null;
            }
        } else if (displayedException != null) {
            ImGui.setNextWindowPos(center.x, center.y, 1, 0.5f, 0.5f);
            if (!ImGui.isPopupOpen("###BrowserErrorPopup")) {
                ImGui.openPopup("###BrowserErrorPopup");
            }
            if (ImGuiHelper.beginPopupModalCloseable(displayedException.getClass().getSimpleName() + "###BrowserErrorPopup", 64)) {
                ImGui.pushTextWrapPos(600.0f);
                ImGui.text(displayedException.getMessage());
                ImGui.popTextWrapPos();
                if (ImGui.button(AxiomI18n.get("axiom.editorui.window.blueprint_browser.close"))) {
                    displayedException = null;
                    ImGui.closeCurrentPopup();
                }
                ImGuiHelper.endPopupModalCloseable();
            }
            if (!ImGui.isPopupOpen("###BrowserErrorPopup")) {
                displayedException = null;
            }
        } else if (moveFileOperation != null && BlueprintBrowserWindow.moveFileOperation.pendingOverwriteConfirmation) {
            if (!ImGui.isPopupOpen("###BrowserOverwritePopup")) {
                ImGui.openPopup("###BrowserOverwritePopup");
            }
            ImGui.setNextWindowPos(center.x, center.y, 1, 0.5f, 0.5f);
            if (ImGuiHelper.beginPopupModalCloseable(AxiomI18n.get("axiom.editorui.window.blueprint_browser.move_file") + "###BrowserOverwritePopup", 64)) {
                ImGui.pushTextWrapPos(600.0f);
                ImGui.text(AxiomI18n.get("axiom.editorui.window.blueprint_browser.move_file_already_exists", BlueprintBrowserWindow.moveFileOperation.file.path().getFileName()));
                ImGui.popTextWrapPos();
                if (ImGui.button(AxiomI18n.get("axiom.editorui.window.blueprint_browser.move_file_overwrite"))) {
                    BlueprintBrowserWindow.moveFileOperation.overwriteConfirmation = true;
                }
                ImGui.sameLine();
                if (ImGui.button(AxiomI18n.get("axiom.editorui.window.blueprint_browser.close"))) {
                    moveFileOperation = null;
                    ImGui.closeCurrentPopup();
                }
                ImGuiHelper.endPopupModalCloseable();
            }
            if (!ImGui.isPopupOpen("###BrowserOverwritePopup") && moveFileOperation != null) {
                moveFileOperation = null;
            }
        }
        ImGui.beginGroup();
        float size = (175.0f - ImGui.getStyle().getItemSpacingX()) / 2.0f;
        if (ImGui.button(AxiomI18n.get("axiom.editorui.window.blueprint_browser.reload"), (int)Math.floor(size), 0.0f)) {
            reloadDirectoryStructure = true;
        }
        ImGui.sameLine();
        boolean bl = backDisabled = currentDirectory == null || currentDirectory.parent() == null;
        if (backDisabled) {
            ImGui.beginDisabled();
        }
        if (ImGui.button(AxiomI18n.get("axiom.editorui.window.blueprint_browser.go_back"), (int)Math.ceil(size), 0.0f)) {
            pendingSelectDirectory = currentDirectory.parent();
        }
        if (backDisabled) {
            ImGui.endDisabled();
        }
        if (ImGui.beginChild("DirList", 175.0f, ImGui.getWindowHeight() - 100.0f, false, 2048)) {
            if (rootDirectory != null) {
                BlueprintBrowserWindow.renderDirectoryOverview(rootDirectory, "");
            }
            if (rootServerBlueprintDirectory != null) {
                BlueprintBrowserWindow.renderDirectoryOverview(rootServerBlueprintDirectory, "");
            } else if (!Axiom.getInstance().hasCommercialLicense() && !class_310.method_1551().method_1496()) {
                int flags = 4608;
                if (ImGui.treeNodeEx("Server Blueprints", flags)) {
                    ImGui.treePop();
                }
                ImGuiHelper.tooltip("Server Blueprints are a Commercial License feature");
                ImGuiHelper.openCommercialLicenseOnClick();
            }
        }
        ImGui.endChild();
        ImGui.endGroup();
        ImGui.sameLine();
        ImGui.beginGroup();
        float tagFilterDropdownSize = ImGui.getContentRegionAvailX() * 0.75f;
        ImGui.setNextItemWidth(ImGui.getContentRegionAvailX() * 0.25f);
        if (ImGui.inputText("##Search", searchString)) {
            String search = ImGuiHelper.getString(searchString);
            if (currentDirectory != null) {
                currentDirectory.search(search, filteredTags);
            }
        }
        if (currentDirectory != null) {
            Map<String, Integer> tagsWithCount = currentDirectory.tagsWithCount();
            boolean broke = false;
            for (String string : filteredTags) {
                if (tagsWithCount.containsKey(string)) continue;
                ImGui.sameLine();
                if (!BlueprintBrowserWindow.renderTagFilterButton(string, 0)) continue;
                broke = true;
                break;
            }
            if (!broke) {
                ArrayList<Map.Entry<String, Integer>> list = new ArrayList<Map.Entry<String, Integer>>(tagsWithCount.entrySet());
                list.sort(Comparator.comparingInt(entry -> -((Integer)entry.getValue()).intValue()));
                for (Map.Entry entry2 : list) {
                    ImGui.sameLine();
                    if (!BlueprintBrowserWindow.renderTagFilterButton((String)entry2.getKey(), (Integer)entry2.getValue())) continue;
                    broke = true;
                    break;
                }
            }
            ImVec2 buttonPos = ImGui.getCursorScreenPos();
            if (broke && ImGui.arrowButton("##TagFilterDropdownButton", 3)) {
                ImGui.openPopup("##TagFilterDropdown");
            }
            float f = ImGui.getFrameHeight();
            ImGui.setNextWindowPos(buttonPos.x + f, buttonPos.y + f, 1, 1.0f, 0.0f);
            if (ImGuiHelper.beginPopup("##TagFilterDropdown")) {
                BlueprintBrowserWindow.renderTagFilterDropdown(tagFilterDropdownSize, tagsWithCount);
                ImGui.endPopup();
            }
        }
        float bottomBarHeight = ImGui.getFrameHeightWithSpacing() + ImGui.getStyle().getItemSpacingY();
        if (ImGui.beginChild("Browser", 0.0f, ImGui.getContentRegionAvailY() - bottomBarHeight)) {
            final int countPerRow = Math.max(1, (int)Math.floor((ImGui.getContentRegionAvailX() + ImGui.getStyle().getItemSpacingX() + 2.0f) / (100.0f + ImGui.getStyle().getItemSpacingX())));
            if (ImGui.isWindowHovered() && ImGui.isMouseClicked(1)) {
                ImGui.openPopup("##BrowserCtxMenu");
            }
            if (currentDirectory != null && currentDirectory.path().real() != null && ImGuiHelper.beginPopup("##BrowserCtxMenu")) {
                if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.window.blueprint_browser.add_folder"))) {
                    Path currentDir = currentDirectory.path().real();
                    boolean bl2 = false;
                    while (true) {
                        void var8_24;
                        void var7_18;
                        if (var7_18 == false) {
                            String string = AxiomI18n.get("axiom.editorui.window.blueprint_browser.new_folder");
                        } else {
                            String string = AxiomI18n.get("axiom.editorui.window.blueprint_browser.new_folder_i", Integer.toString((int)var7_18));
                        }
                        Path folderPath = currentDir.resolve((String)var8_24);
                        try {
                            Files.createDirectory(folderPath, new FileAttribute[0]);
                            updatedBlueprintPaths.add(folderPath);
                            break;
                        }
                        catch (FileAlreadyExistsException ignored) {
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            break;
                        }
                        ++var7_18;
                    }
                }
                if (ImGui.beginMenu(AxiomI18n.get("axiom.editorui.window.blueprint_browser.sort_by"))) {
                    if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.window.blueprint_browser.sort_by.name"))) {
                        currentDirectory.sort(BlueprintDirectory.SortMode.NAME);
                    }
                    if (ImGui.beginMenu(AxiomI18n.get("axiom.editorui.window.blueprint_browser.sort_by.block_count"))) {
                        if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.window.blueprint_browser.sort_by.ascending"))) {
                            currentDirectory.sort(BlueprintDirectory.SortMode.BLOCK_COUNT_ASC);
                        }
                        if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.window.blueprint_browser.sort_by.descending"))) {
                            currentDirectory.sort(BlueprintDirectory.SortMode.BLOCK_COUNT_DESC);
                        }
                        ImGui.endMenu();
                    }
                    ImGui.endMenu();
                }
                ImGui.endPopup();
            }
            if (currentDirectory != null && !currentDirectory.searchedBlueprints().isEmpty()) {
                int vcount = (int)Math.ceil((float)currentDirectory.searchedBlueprints().size() / (float)countPerRow);
                float f = 100.0f + ImGui.getTextLineHeightWithSpacing() * 2.0f + 7.0f + ImGui.getStyle().getItemSpacingY();
                ImGuiListClipper.forEach(vcount, (int)f, new ImListClipperCallback(){
                    private BlueprintOrDirectory currentBlueprintOrDirectory = null;
                    private boolean ended = false;

                    @Override
                    public void accept(int index) {
                        if (this.ended) {
                            return;
                        }
                        int from = index * countPerRow;
                        int to = Math.min(from + countPerRow, currentDirectory.searchedBlueprints().size());
                        if (this.currentBlueprintOrDirectory == null) {
                            this.currentBlueprintOrDirectory = currentDirectory.setSearchVisibleStart(from);
                            if (this.currentBlueprintOrDirectory == null) {
                                this.ended = true;
                                return;
                            }
                        }
                        for (int i = from; i < to; ++i) {
                            BlueprintOrDirectory blueprintOrDirectory = this.currentBlueprintOrDirectory;
                            if (blueprintOrDirectory instanceof BlueprintOrDirectory.Dir) {
                                BlueprintOrDirectory.Dir dir = (BlueprintOrDirectory.Dir)blueprintOrDirectory;
                                ImGui.pushID(i);
                                BlueprintBrowserWindow.renderBlueprintDirectory(dir, i, i == to - 1);
                                ImGui.popID();
                            } else if (blueprintOrDirectory instanceof BlueprintOrDirectory.Bp) {
                                BlueprintOrDirectory.Bp bp = (BlueprintOrDirectory.Bp)blueprintOrDirectory;
                                ImGui.pushID(i);
                                BlueprintBrowserWindow.renderBlueprintLoaded(bp, i, i == to - 1);
                                ImGui.popID();
                            }
                            this.currentBlueprintOrDirectory = blueprintOrDirectory.nextSearchNode;
                            if (this.currentBlueprintOrDirectory == null) {
                                this.ended = true;
                                return;
                            }
                            if (i >= to - 1) continue;
                            ImGui.sameLine();
                        }
                    }
                });
            }
        }
        ImGui.endChild();
        ImGui.endGroup();
        ImGui.separator();
        if (ImGui.button(AxiomI18n.get("axiom.editorui.window.blueprint_browser.open_folder"))) {
            Path rootPath = FabricLoader.getInstance().getConfigDir().resolve("axiom").resolve("blueprints");
            class_156.method_668().method_673(rootPath.toUri());
        }
        ImGui.sameLine();
        BlueprintConfiguration blueprintConfig = Configuration.blueprint;
        if (ImGui.checkbox(AxiomI18n.get("axiom.editorui.window.blueprint_browser.automatically_refresh"), blueprintConfig.automaticRefreshing)) {
            blueprintConfig.automaticRefreshing = !blueprintConfig.automaticRefreshing;
        }
        ImGui.sameLine();
    }

    private static void renderTagFilterDropdown(float width, Map<String, Integer> tagsWithCount) {
        record Tag(String tag, String tagWithCount) {
        }
        ArrayList<Tag> tags = new ArrayList<Tag>();
        for (String string : filteredTags) {
            if (tagsWithCount.containsKey(string)) continue;
            tags.add(new Tag(string, string + " (0)"));
        }
        for (Map.Entry entry : tagsWithCount.entrySet()) {
            tags.add(new Tag((String)entry.getKey(), (String)entry.getKey() + " (" + String.valueOf(entry.getValue()) + ")"));
        }
        int minLines = 1;
        int n = 8;
        float itemSpacingX = ImGui.getStyle().getItemSpacingX();
        float framePaddingX = ImGui.getStyle().getFramePaddingX();
        float availableSpace = width;
        int lines = 0;
        boolean scrollbar = false;
        if (minLines == n) {
            lines = minLines;
            scrollbar = true;
        } else {
            float consumedWidth = 0.0f;
            for (Tag tag : tags) {
                float elementWidth = framePaddingX * 2.0f + ImGuiHelper.calcTextWidth(tag.tagWithCount);
                if (consumedWidth + elementWidth < availableSpace && consumedWidth > 0.0f) {
                    consumedWidth += elementWidth + itemSpacingX;
                    continue;
                }
                consumedWidth = elementWidth + itemSpacingX;
                if (++lines <= n) continue;
                lines = n;
                scrollbar = true;
                break;
            }
            if (lines < minLines) {
                lines = minLines;
            }
        }
        float lineHeight = (float)ImGui.getFontSize() + ImGui.getStyle().getFramePaddingY() * 2.0f + ImGui.getStyle().getItemSpacingY();
        if (ImGui.beginChild("##TagFilterDropdownScroller", width, lineHeight * (float)lines - ImGui.getStyle().getItemSpacingY())) {
            if (scrollbar) {
                availableSpace -= ImGui.getStyle().getScrollbarSize();
            }
            boolean disabledAlpha = false;
            float consumedWidth = 0.0f;
            for (Tag tag : tags) {
                float elementWidth = framePaddingX * 2.0f + ImGuiHelper.calcTextWidth(tag.tagWithCount);
                if (consumedWidth + elementWidth < availableSpace && consumedWidth > 0.0f) {
                    ImGui.sameLine();
                    consumedWidth += elementWidth + itemSpacingX;
                } else {
                    consumedWidth = elementWidth + itemSpacingX;
                }
                boolean contains = filteredTags.contains(tag.tag);
                if (contains != disabledAlpha) {
                    disabledAlpha = contains;
                    if (disabledAlpha) {
                        ImGuiHelper.pushStyleVar(0, ImGui.getStyle().getAlpha() * ImGui.getStyle().getDisabledAlpha());
                    } else {
                        ImGuiHelper.popStyleVar();
                    }
                }
                if (!ImGui.button(tag.tagWithCount + "##" + tag.tag)) continue;
                if (contains) {
                    filteredTags.remove(tag.tag);
                } else {
                    filteredTags.add(tag.tag);
                }
                filteredTagsChanged = true;
            }
            if (disabledAlpha) {
                ImGuiHelper.popStyleVar();
            }
        }
        ImGui.endChild();
    }

    private static boolean renderTagFilterButton(String tag, int count) {
        float needed;
        String display = tag + " (" + count + ")";
        float available = ImGui.getContentRegionAvailX();
        if (available < (needed = ImGui.getStyle().getFramePaddingX() * 2.0f + ImGuiHelper.calcTextWidth(display) + ImGui.getStyle().getItemSpacingX() + ImGui.getFrameHeight())) {
            return true;
        }
        boolean contains = filteredTags.contains(tag);
        if (contains) {
            ImGuiHelper.pushStyleVar(0, ImGui.getStyle().getAlpha() * ImGui.getStyle().getDisabledAlpha());
        }
        if (ImGui.button(display + "##" + tag)) {
            if (contains) {
                filteredTags.remove(tag);
            } else {
                filteredTags.add(tag);
            }
            filteredTagsChanged = true;
        }
        if (contains) {
            ImGuiHelper.popStyleVar();
        }
        return false;
    }

    private static void editBlueprintPopup() {
        if (!BlueprintBrowserWindow.editBlueprintData.previewLocked && BlueprintBrowserWindow.editBlueprintData.blockRegion.count() < 0x1000000) {
            ImGui.image(BlueprintBrowserWindow.editBlueprintData.blueprintPreview.render(512, true, true), 256.0f, 256.0f, 0.0f, 1.0f, 1.0f, 0.0f);
            if (BlueprintBrowserWindow.editBlueprintData.isRotating) {
                if (!ImGui.isMouseDown(0)) {
                    BlueprintBrowserWindow.editBlueprintData.isRotating = false;
                    BlueprintBrowserWindow.editBlueprintData.blueprintPreview.mouseReleased();
                } else {
                    float mouseX = ImGui.getMousePosX();
                    float mouseY = ImGui.getMousePosY();
                    BlueprintBrowserWindow.editBlueprintData.blueprintPreview.mouseMoved(mouseX - BlueprintBrowserWindow.editBlueprintData.lastMouseX, mouseY - BlueprintBrowserWindow.editBlueprintData.lastMouseY, EditorUI.isCtrlOrCmdDown());
                    BlueprintBrowserWindow.editBlueprintData.lastMouseX = mouseX;
                    BlueprintBrowserWindow.editBlueprintData.lastMouseY = mouseY;
                }
            } else if (ImGui.isItemClicked(0)) {
                BlueprintBrowserWindow.editBlueprintData.isRotating = true;
                BlueprintBrowserWindow.editBlueprintData.lastMouseX = ImGui.getMousePosX();
                BlueprintBrowserWindow.editBlueprintData.lastMouseY = ImGui.getMousePosY();
            }
        }
        ImGui.inputText(AxiomI18n.get("axiom.editorui.window.create_blueprint.name"), BlueprintBrowserWindow.editBlueprintData.blueprintName);
        ImGui.inputText(AxiomI18n.get("axiom.editorui.window.create_blueprint.author"), BlueprintBrowserWindow.editBlueprintData.authorName);
        BlueprintBrowserWindow.editBlueprintData.tagListWidget.render(256);
        if (!BlueprintBrowserWindow.editBlueprintData.previewLocked) {
            float[] angleArray = new float[]{BlueprintBrowserWindow.editBlueprintData.blueprintPreview.getYaw(), BlueprintBrowserWindow.editBlueprintData.blueprintPreview.getPitch()};
            if (ImGui.inputFloat2(AxiomI18n.get("axiom.editorui.window.create_blueprint.angle"), angleArray, "%.2f")) {
                BlueprintBrowserWindow.editBlueprintData.blueprintPreview.setYaw(angleArray[0], false);
                BlueprintBrowserWindow.editBlueprintData.blueprintPreview.setPitch(angleArray[1], false);
            }
        }
        if (ImGui.button(AxiomI18n.get("axiom.editorui.window.create_blueprint.save"))) {
            class_1011 nativeImage;
            if (BlueprintBrowserWindow.editBlueprintData.blockRegion.count() < 0x1000000) {
                BlueprintBrowserWindow.editBlueprintData.blueprintPreview.render(960, false, false);
                nativeImage = BlueprintBrowserWindow.editBlueprintData.blueprintPreview.toNativeImage(96, true);
            } else {
                nativeImage = new class_1011(96, 96, true);
            }
            BlueprintHeader header = new BlueprintHeader(ImGuiHelper.getString(BlueprintBrowserWindow.editBlueprintData.blueprintName).trim(), ImGuiHelper.getString(BlueprintBrowserWindow.editBlueprintData.authorName).trim(), BlueprintBrowserWindow.editBlueprintData.tagListWidget.tags(), BlueprintBrowserWindow.editBlueprintData.blueprintPreview.getYaw(), BlueprintBrowserWindow.editBlueprintData.blueprintPreview.getPitch(), false, BlueprintBrowserWindow.editBlueprintData.blockRegion.count());
            updatedBlueprintPaths.add(BlueprintBrowserWindow.editBlueprintData.path);
            try (BufferedOutputStream outputStream = new BufferedOutputStream(Files.newOutputStream(BlueprintBrowserWindow.editBlueprintData.path, new OpenOption[0]));){
                BlueprintIo.write(outputStream, header, nativeImage, BlueprintBrowserWindow.editBlueprintData.blockRegion, BlueprintBrowserWindow.editBlueprintData.blockEntities);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            nativeImage.close();
            ImGui.closeCurrentPopup();
            BlueprintBrowserWindow.editBlueprintData.fallbackPreview.close();
            editBlueprintData = null;
        }
        ImGui.sameLine();
        if (ImGui.button(AxiomI18n.get("axiom.widget.cancel"))) {
            ImGui.closeCurrentPopup();
            BlueprintBrowserWindow.editBlueprintData.fallbackPreview.close();
            editBlueprintData = null;
        }
    }

    private static void renderBlueprintDirectory(BlueprintOrDirectory.Dir directory, int index, boolean last) {
        float lineX;
        BlueprintOrDirectory blueprintOrDirectory;
        ImVec2 textSize = new ImVec2();
        ImGui.calcTextSize(textSize, directory.blueprintDirectory.dirName(), 100.0f);
        float childHeight = 100.0f + ImGui.getTextLineHeightWithSpacing() * 2.0f + 7.0f;
        boolean openCtxMenu = false;
        ImVec2 startCursorPos = ImGui.getCursorScreenPos();
        float itemSpacingX = ImGui.getStyle().getItemSpacingX();
        ImGui.setCursorScreenPos(startCursorPos.x - itemSpacingX, startCursorPos.y);
        ImGui.dummy(itemSpacingX + 20.0f, childHeight);
        if (ImGui.beginDragDropTarget()) {
            blueprintOrDirectory = (BlueprintOrDirectory)ImGui.acceptDragDropPayload("BlueprintOrDirectory", 3072);
            if (blueprintOrDirectory != null && directory.prevNode != blueprintOrDirectory && directory != blueprintOrDirectory) {
                lineX = startCursorPos.x - ImGui.getStyle().getItemSpacingX() / 2.0f;
                ImGui.getForegroundDrawList().addRectFilled(lineX - 1.0f, startCursorPos.y, lineX + 1.0f, startCursorPos.y + 100.0f + 3.0f, ImGui.getColorU32(50));
                if (ImGui.isMouseReleased(0)) {
                    moveFileOperation = new MoveFileOperation(currentDirectory, currentDirectory, blueprintOrDirectory);
                    BlueprintBrowserWindow.moveFileOperation.repositionBefore = true;
                    BlueprintBrowserWindow.moveFileOperation.repositionReference = directory;
                }
            }
            ImGui.endDragDropTarget();
        }
        ImGui.setCursorScreenPos(startCursorPos.x + 80.0f, startCursorPos.y);
        ImGui.dummy(last ? ImGui.getContentRegionAvailX() : 20.0f, childHeight);
        if (ImGui.beginDragDropTarget()) {
            blueprintOrDirectory = (BlueprintOrDirectory)ImGui.acceptDragDropPayload("BlueprintOrDirectory", 3072);
            if (blueprintOrDirectory != null && directory.nextNode != blueprintOrDirectory && directory != blueprintOrDirectory) {
                lineX = startCursorPos.x + 100.0f + ImGui.getStyle().getItemSpacingX() / 2.0f;
                ImGui.getForegroundDrawList().addRectFilled(lineX - 1.0f, startCursorPos.y, lineX + 1.0f, startCursorPos.y + 100.0f + 3.0f, ImGui.getColorU32(50));
                if (ImGui.isMouseReleased(0)) {
                    moveFileOperation = new MoveFileOperation(currentDirectory, currentDirectory, blueprintOrDirectory);
                    BlueprintBrowserWindow.moveFileOperation.repositionBefore = false;
                    BlueprintBrowserWindow.moveFileOperation.repositionReference = directory;
                }
            }
            ImGui.endDragDropTarget();
        }
        ImGui.setCursorScreenPos(startCursorPos.x, startCursorPos.y);
        if (ImGui.beginChild("", 100.0f, childHeight, false, 59)) {
            ImVec2 pos = ImGui.getCursorScreenPos();
            ImGuiHelper.pushStyleVar(11, 0.0f, 0.0f);
            ImVec2 buttonStartPos = ImGui.getCursorScreenPos();
            ImGui.setCursorScreenPos(buttonStartPos.x + 20.0f, buttonStartPos.y);
            ImGui.dummy(60.0f, 100.0f);
            if (ImGui.beginDragDropTarget()) {
                BlueprintOrDirectory blueprintOrDirectory2 = (BlueprintOrDirectory)ImGui.acceptDragDropPayload("BlueprintOrDirectory", 3072);
                if (blueprintOrDirectory2 != null && directory != blueprintOrDirectory2) {
                    ImVec2 min2 = ImGui.getItemRectMin();
                    ImVec2 max2 = ImGui.getItemRectMax();
                    ImGui.getForegroundDrawList().addRect(min2.x - 3.5f - 20.0f, min2.y - 3.5f, max2.x + 3.5f + 20.0f, max2.y + 3.5f, ImGui.getColorU32(50), 0.0f, 0, 2.0f);
                    if (ImGui.isMouseReleased(0)) {
                        moveFileOperation = new MoveFileOperation(currentDirectory, directory.blueprintDirectory, blueprintOrDirectory2);
                    }
                }
                ImGui.endDragDropTarget();
            }
            ImGui.setCursorScreenPos(buttonStartPos.x, buttonStartPos.y);
            ImGui.pushFont(EditorUI.icons);
            if (ImGui.button("\ue908", 100.0f, 100.0f)) {
                pendingSelectDirectory = directory.blueprintDirectory;
            }
            openCtxMenu = ImGui.isItemClicked(1);
            if (ImGui.beginDragDropSource()) {
                ImGui.setDragDropPayload("BlueprintOrDirectory", directory);
                ImGui.text("\ue908");
                ImGui.endDragDropSource();
            }
            ImGui.popFont();
            String countText = NumberFormat.getInstance().format(directory.blueprintDirectory.blueprints().size());
            ImVec2 countTextSize = new ImVec2();
            ImGui.calcTextSize(countTextSize, countText);
            ImGui.getWindowDrawList().addText(pos.x + 50.0f - countTextSize.x / 2.0f, pos.y + 5.0f + 50.0f - countTextSize.y / 2.0f, -9155541, countText);
            ImVec2 cursorPos = ImGui.getCursorPos();
            ImGui.setCursorPos(cursorPos.x + (100.0f - textSize.x) / 2.0f, cursorPos.y);
            ImGui.pushTextWrapPos(100.0f);
            ImGui.text(directory.blueprintDirectory.dirName());
            ImGui.popTextWrapPos();
            ImGuiHelper.popStyleVar();
        }
        ImGui.endChild();
        if (directory.path().real() != null) {
            Path path = directory.path().real();
            boolean openRename = false;
            if (openCtxMenu) {
                ImGui.openPopup("###BlueprintCtxMenu" + index);
            }
            if (ImGuiHelper.beginPopup("###BlueprintCtxMenu" + index)) {
                if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.window.blueprint_browser.rename_file"))) {
                    openRename = true;
                }
                if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.window.blueprint_browser.delete"))) {
                    try {
                        Files.delete(path);
                        BlueprintDirectory parent = dirStructureMap.get(path.getParent());
                        if (parent != null) {
                            parent.remove(directory.path());
                        }
                    }
                    catch (FileNotFoundException | NoSuchFileException e) {
                        noLongerExistsErrorFileName = directory.path().getFileName();
                    }
                    catch (Exception e) {
                        displayedException = e;
                        e.printStackTrace();
                    }
                }
                ImGui.endPopup();
            }
            BlueprintBrowserWindow.renameContextMenu(directory, index, openRename);
        }
    }

    private static void renderBlueprintLoaded(BlueprintOrDirectory.Bp blueprint, int index, boolean last) {
        boolean fileBasedBlueprint = blueprint.path().real() != null;
        String textToRender = blueprint.blueprint.name().trim();
        if (textToRender.isBlank()) {
            textToRender = AxiomI18n.get("axiom.editorui.window.blueprint_browser.unnamed_blueprint");
        }
        ImVec2 textSize = new ImVec2();
        ImGui.calcTextSize(textSize, textToRender, 100.0f);
        float childHeight = 100.0f + ImGui.getTextLineHeightWithSpacing() * 2.0f + 7.0f;
        boolean openCtxMenu = false;
        if (fileBasedBlueprint) {
            float lineX;
            BlueprintOrDirectory blueprintOrDirectory;
            ImVec2 startCursorPos = ImGui.getCursorScreenPos();
            float itemSpacingX = ImGui.getStyle().getItemSpacingX();
            ImGui.setCursorScreenPos(startCursorPos.x - itemSpacingX, startCursorPos.y);
            ImGui.dummy(itemSpacingX + 50.0f, childHeight);
            if (ImGui.beginDragDropTarget()) {
                blueprintOrDirectory = (BlueprintOrDirectory)ImGui.acceptDragDropPayload("BlueprintOrDirectory", 3072);
                if (blueprintOrDirectory != null && blueprint.prevNode != blueprintOrDirectory && blueprint != blueprintOrDirectory) {
                    lineX = startCursorPos.x - ImGui.getStyle().getItemSpacingX() / 2.0f;
                    ImGui.getForegroundDrawList().addRectFilled(lineX - 1.0f, startCursorPos.y, lineX + 1.0f, startCursorPos.y + 100.0f + 3.0f, ImGui.getColorU32(50));
                    if (ImGui.isMouseReleased(0)) {
                        moveFileOperation = new MoveFileOperation(currentDirectory, currentDirectory, blueprintOrDirectory);
                        BlueprintBrowserWindow.moveFileOperation.repositionBefore = true;
                        BlueprintBrowserWindow.moveFileOperation.repositionReference = blueprint;
                    }
                }
                ImGui.endDragDropTarget();
            }
            ImGui.setCursorScreenPos(startCursorPos.x + 50.0f, startCursorPos.y);
            ImGui.dummy(last ? ImGui.getContentRegionAvailX() : 50.0f, childHeight);
            if (ImGui.beginDragDropTarget()) {
                blueprintOrDirectory = (BlueprintOrDirectory)ImGui.acceptDragDropPayload("BlueprintOrDirectory", 3072);
                if (blueprintOrDirectory != null && blueprint.nextNode != blueprintOrDirectory && blueprint != blueprintOrDirectory) {
                    lineX = startCursorPos.x + 100.0f + ImGui.getStyle().getItemSpacingX() / 2.0f;
                    ImGui.getForegroundDrawList().addRectFilled(lineX - 1.0f, startCursorPos.y, lineX + 1.0f, startCursorPos.y + 100.0f + 3.0f, ImGui.getColorU32(50));
                    if (ImGui.isMouseReleased(0)) {
                        moveFileOperation = new MoveFileOperation(currentDirectory, currentDirectory, blueprintOrDirectory);
                        BlueprintBrowserWindow.moveFileOperation.repositionBefore = false;
                        BlueprintBrowserWindow.moveFileOperation.repositionReference = blueprint;
                    }
                }
                ImGui.endDragDropTarget();
            }
            ImGui.setCursorScreenPos(startCursorPos.x, startCursorPos.y);
        }
        if (ImGui.beginChild("", 100.0f, childHeight, false, 59)) {
            ImGuiHelper.pushStyleVar(11, 0.0f, 0.0f);
            Thumbnail thumbnail = loadedBlueprintThumbnails.get(blueprint.path());
            if (thumbnail != null) {
                class_1043 texture = thumbnail.getTextureOrMissing();
                boolean openBlueprint = ImGui.imageButton(texture.method_4624(), 96.0f, 96.0f, 0.0f, 1.0f, 1.0f, 0.0f, 2);
                openCtxMenu = ImGui.isItemClicked(1);
                if (fileBasedBlueprint && ImGui.beginDragDropSource()) {
                    ImGui.setDragDropPayload("BlueprintOrDirectory", blueprint);
                    ImGui.image(texture.method_4624(), 100.0f, 100.0f, 0.0f, 1.0f, 1.0f, 0.0f);
                    ImGui.endDragDropSource();
                }
                if (openBlueprint) {
                    if (fileBasedBlueprint) {
                        try (BufferedInputStream inputStream = new BufferedInputStream(Files.newInputStream(blueprint.path().real(), new OpenOption[0]));){
                            Blueprint fullBlueprint = BlueprintIo.readBlueprint(inputStream);
                            if (fullBlueprint.blockRegion().isEmpty()) {
                                class_310.method_1551().field_1724.method_43496((class_2561)class_2561.method_43470((String)"Failed to load blueprint: empty").method_27692(class_124.field_1061));
                                fullBlueprint.thumbnail().close();
                            } else {
                                boolean success = callback.test(fullBlueprint);
                                if (!success) {
                                    callback = BlueprintBrowserWindow::defaultCallback;
                                    selectMultiple = false;
                                    callback.test(fullBlueprint);
                                }
                            }
                            if (!(selectMultiple && ImGui.getIO().getKeyShift() || EditorWindowType.BLUEPRINT_BROWSER.isDocked())) {
                                EditorWindowType.BLUEPRINT_BROWSER.setOpen(false);
                            }
                        }
                        catch (FileNotFoundException | NoSuchFileException e) {
                            noLongerExistsErrorFileName = blueprint.path().getFileName();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    } else {
                        pendingServerBlueprintDownload = blueprint.path().fakePath();
                        if (pendingServerBlueprintResult != null) {
                            pendingServerBlueprintResult.close();
                            pendingServerBlueprintResult = null;
                        }
                        new AxiomServerboundRequestBlueprint(blueprint.path().fakePath()).send();
                    }
                }
            } else {
                ImGui.button("##LoadingTexturePlaceholder", 100.0f, 100.0f);
            }
            ImVec2 cursorPos = ImGui.getCursorPos();
            ImGui.setCursorPos(cursorPos.x + (100.0f - textSize.x) / 2.0f, cursorPos.y);
            ImGui.pushTextWrapPos(100.0f);
            ImGui.text(textToRender);
            ImGui.popTextWrapPos();
            if (textSize.y > ImGui.getTextLineHeight() + ImGui.getTextLineHeightWithSpacing() && ImGui.isItemHovered()) {
                ImGui.beginTooltip();
                ImGui.pushTextWrapPos((float)ImGui.getFontSize() * 20.0f);
                ImGui.textUnformatted(textToRender);
                ImGui.popTextWrapPos();
                ImGui.endTooltip();
            }
            ImGuiHelper.popStyleVar();
        }
        ImGui.endChild();
        if (fileBasedBlueprint) {
            Path path = blueprint.path().real();
            boolean openRename = false;
            if (openCtxMenu) {
                ImGui.openPopup("###BlueprintCtxMenu" + index);
            }
            if (ImGuiHelper.beginPopup("###BlueprintCtxMenu" + index)) {
                if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.window.blueprint_browser.rename_file"))) {
                    openRename = true;
                }
                if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.window.blueprint_browser.edit_blueprint"))) {
                    try (BufferedInputStream inputStream = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));){
                        Blueprint fullBlueprint = BlueprintIo.readBlueprint(inputStream);
                        if (editBlueprintData != null) {
                            BlueprintBrowserWindow.editBlueprintData.fallbackPreview.close();
                        }
                        editBlueprintData = new EditBlueprintData(path, fullBlueprint.thumbnail(), fullBlueprint.blockRegion(), fullBlueprint.blockEntities());
                        BlueprintBrowserWindow.editBlueprintData.blueprintName.set(fullBlueprint.header().name());
                        BlueprintBrowserWindow.editBlueprintData.authorName.set(fullBlueprint.header().author());
                        BlueprintBrowserWindow.editBlueprintData.tagListWidget.tags().addAll(fullBlueprint.header().tags());
                        BlueprintBrowserWindow.editBlueprintData.blueprintPreview.setYaw(fullBlueprint.header().thumbnailYaw(), false);
                        BlueprintBrowserWindow.editBlueprintData.blueprintPreview.setPitch(fullBlueprint.header().thumbnailPitch(), false);
                        BlueprintBrowserWindow.editBlueprintData.previewLocked = fullBlueprint.header().lockedThumbnail();
                        ImGui.closeCurrentPopup();
                    }
                    catch (FileNotFoundException | NoSuchFileException e) {
                        noLongerExistsErrorFileName = path.getFileName().toString();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.window.blueprint_browser.delete"))) {
                    try {
                        Files.delete(path);
                        BlueprintDirectory parent = dirStructureMap.get(path.getParent());
                        if (parent != null) {
                            parent.remove(blueprint.path());
                        }
                    }
                    catch (FileNotFoundException | NoSuchFileException e) {
                        noLongerExistsErrorFileName = path.getFileName().toString();
                    }
                    catch (Exception e) {
                        displayedException = e;
                        e.printStackTrace();
                    }
                }
                if (rootServerBlueprintDirectory != null && ImGui.menuItem(AxiomI18n.get("axiom.editorui.window.blueprint_browser.upload_to_server"))) {
                    try (BufferedInputStream inputStream = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));){
                        RawBlueprint rawBlueprint = BlueprintIo.readRawBlueprint(inputStream);
                        Path rootPath = FabricLoader.getInstance().getConfigDir().resolve("axiom").resolve("blueprints");
                        Path relative = rootPath.relativize(path);
                        Object relativeStr = relative.toString();
                        relativeStr = ((String)relativeStr).replace("\\", "/");
                        if (!((String)relativeStr).startsWith("/")) {
                            relativeStr = "/" + (String)relativeStr;
                        }
                        new AxiomServerboundUploadBlueprint((String)relativeStr, rawBlueprint).send();
                        ImGui.closeCurrentPopup();
                    }
                    catch (FileNotFoundException | NoSuchFileException e) {
                        noLongerExistsErrorFileName = path.getFileName().toString();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                ImGui.endPopup();
            }
            BlueprintBrowserWindow.renameContextMenu(blueprint, index, openRename);
        }
    }

    private static void renameContextMenu(BlueprintOrDirectory blueprint, int index, boolean openRename) {
        Path path = blueprint.path().real();
        if (openRename) {
            ImGui.openPopup("###BlueprintCtxMenu" + index + "Rename");
            renameFilenameString.set(path.getFileName().toString());
        }
        ImVec2 center = ImGui.getMainViewport().getCenter();
        ImGui.setNextWindowPos(center.x, center.y, 1, 0.5f, 0.5f);
        if (ImGuiHelper.beginPopupModalCloseable(AxiomI18n.get("axiom.editorui.window.blueprint_browser.rename_file") + "###BlueprintCtxMenu" + index + "Rename", 64)) {
            boolean confirm = ImGui.inputText("##Filename", renameFilenameString, 32);
            if (ImGui.button(AxiomI18n.get("axiom.editorui.window.blueprint_browser.confirm")) || confirm) {
                String filename = path.getFileName().toString();
                String newFilename = ImGuiHelper.getString(renameFilenameString);
                if (!newFilename.equals(filename)) {
                    try {
                        Path newPath = path.getParent().resolve(newFilename);
                        BlueprintDirectory from = dirStructureMap.get(path.getParent());
                        BlueprintDirectory to = dirStructureMap.get(newPath.getParent());
                        Files.move(path, newPath, new CopyOption[0]);
                        if (from == to) {
                            from.changeChildPath(path, newPath);
                        }
                    }
                    catch (FileNotFoundException | NoSuchFileException e) {
                        noLongerExistsErrorFileName = path.getFileName().toString();
                    }
                    catch (Exception e) {
                        displayedException = e;
                        e.printStackTrace();
                    }
                }
                ImGui.closeCurrentPopup();
            }
            ImGui.sameLine();
            if (ImGui.button(AxiomI18n.get("axiom.widget.cancel"))) {
                ImGui.closeCurrentPopup();
            }
            ImGuiHelper.endPopupModalCloseable();
        }
    }

    private static Path getNewPath(BlueprintDirectory newDir, BlueprintOrDirectory blueprintOrDirectory) {
        return newDir.path().real().resolve(blueprintOrDirectory.path().getFileName());
    }

    private static void moveBlueprint(BlueprintOrDirectory blueprintOrDirectory, Path path, boolean overwrite) throws IOException {
        CopyOption[] copyOptionArray;
        if (blueprintOrDirectory.path().real().equals(path)) {
            return;
        }
        Path path2 = blueprintOrDirectory.path().real();
        if (overwrite) {
            CopyOption[] copyOptionArray2 = new CopyOption[1];
            copyOptionArray = copyOptionArray2;
            copyOptionArray2[0] = StandardCopyOption.REPLACE_EXISTING;
        } else {
            copyOptionArray = new CopyOption[]{};
        }
        Files.move(path2, path, copyOptionArray);
    }

    private static class MoveFileOperation {
        boolean pendingOverwriteConfirmation = false;
        boolean overwriteConfirmation = false;
        BlueprintDirectory from;
        BlueprintDirectory to;
        BlueprintOrDirectory file;
        BlueprintOrDirectory repositionReference;
        boolean repositionBefore;

        public MoveFileOperation(BlueprintDirectory from, BlueprintDirectory to, BlueprintOrDirectory file) {
            this.from = from;
            this.to = to;
            this.file = file;
        }
    }

    public record Thumbnail(class_1043 dynamicTexture) implements AutoCloseable
    {
        public class_1043 getTextureOrMissing() {
            return this.dynamicTexture != null ? this.dynamicTexture : class_1047.method_4540();
        }

        @Override
        public void close() {
            if (this.dynamicTexture != null) {
                this.dynamicTexture.close();
            }
        }
    }

    public static class EditBlueprintData {
        Path path;
        ChunkedBlockRegion blockRegion;
        Long2ObjectMap<CompressedBlockEntity> blockEntities;
        boolean isRotating = false;
        float lastMouseX = 0.0f;
        float lastMouseY = 0.0f;
        boolean previewLocked = false;
        class_1043 fallbackPreview;
        BlueprintPreview blueprintPreview = new BlueprintPreview();
        ImString blueprintName = new ImString();
        ImString authorName = new ImString();
        TagListWidget tagListWidget = new TagListWidget();

        public EditBlueprintData(Path path, class_1043 fallbackPreview, ChunkedBlockRegion blockRegion, Long2ObjectMap<CompressedBlockEntity> blockEntities) {
            this.path = path;
            this.blockRegion = blockRegion;
            this.blockEntities = blockEntities;
            this.fallbackPreview = fallbackPreview;
            this.blueprintPreview.setBlockRegion(blockRegion);
        }
    }
}

